package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.WorkflowType;
import gov.va.vinci.dart.db.WorkflowTypeDAO;

public class WorkflowTypeDAOMock implements WorkflowTypeDAO {
	private static final HashMap<Integer,WorkflowType> IDHash = new HashMap<Integer,WorkflowType>();
	private static final HashMap<String,WorkflowType> NameHash = new HashMap<String,WorkflowType>();
	
	private static boolean initialized = false;

	
	@Override
	public WorkflowType findById(int workflowTypeId) throws ObjectNotFoundException {
		initializeWorkflowTypeHash();

		WorkflowType result = IDHash.get(workflowTypeId);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}

	@Override
	public WorkflowType findByName(String name) throws ObjectNotFoundException {
		initializeWorkflowTypeHash();

		WorkflowType result = NameHash.get(name);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}

	@Override
	public List<WorkflowType> listAll() {
		List<WorkflowType> result = new ArrayList<WorkflowType>();
		
		initializeWorkflowTypeHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	private void initializeWorkflowTypeHash() {
		if (initialized == true) {
			return;
		}

		
		WorkflowType wt = new WorkflowType(1);
		wt.setName("Operational Request Workflow");
		wt.setDescription("Operational Request Workflow");
		IDHash.put(wt.getId(), wt);
		NameHash.put(wt.getName(), wt);
		
		wt = new WorkflowType(2);
		wt.setName("NDS Workflow");
		wt.setDescription("NDS Workflow");
		IDHash.put(wt.getId(), wt);
		NameHash.put(wt.getName(), wt);
		
		wt = new WorkflowType(3);
		wt.setName("Research Request Workflow");
		wt.setDescription("Research Request Workflow");
		IDHash.put(wt.getId(), wt);
		NameHash.put(wt.getName(), wt);
		
		wt = new WorkflowType(4);
		wt.setName("Independent Workflow");
		wt.setDescription("Independent Workflow");
		IDHash.put(wt.getId(), wt);
		NameHash.put(wt.getName(), wt);

		
		initialized = true;	//initialized the hash
	}
}
